% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_plot.R
\name{ff_plot}
\alias{ff_plot}
\alias{finalfit_plot}
\title{Produce a table and plot}
\usage{
ff_plot(.data, dependent, explanatory, ...)

finalfit_plot(.data, dependent, explanatory, ...)
}
\arguments{
\item{.data}{Data frame.}

\item{dependent}{Character vector of length 1.}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{...}{Pass arguments \code{\link{or_plot}}, \code{\link{hr_plot}}, or
\code{\link{coefficient_plot}}}
}
\value{
A table and a plot using \code{\link{ggplot2}}
}
\description{
Wraps \code{\link{or_plot}}, \code{\link{hr_plot}}, and
\code{\link{coefficient_plot}} and sends to the appropriate method depending
on the dependent variable type.
}
\examples{
# Coefficient plot
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "nodes"
colon_s \%>\%
	ff_plot(dependent, explanatory)

# Odds ratio plot
dependent = "mort_5yr"
colon_s \%>\%
	ff_plot(dependent, explanatory)

	# Hazard ratio plot	
dependent = "Surv(time, status)"
colon_s \%>\%
	ff_plot(dependent, explanatory, dependent_label = "Survival")
}
\seealso{
Other finalfit plot functions: 
\code{\link{coefficient_plot}()},
\code{\link{hr_plot}()},
\code{\link{or_plot}()},
\code{\link{surv_plot}()}
}
\concept{finalfit plot functions}
