% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPDF.R
\name{findPDF}
\alias{findPDF}
\title{Find PDF files by content with pattern matching}
\usage{
findPDF(path = ".", pattern = "Hello World", case.sensitive = TRUE,
  show.results = TRUE, copy = FALSE, folder = "findPDF",
  overwrite = TRUE)
}
\arguments{
\item{path}{a character vector, path to be scanned. The default corresponds to the working directory, getwd().}

\item{pattern}{a pattern (regular expression) to search for.}

\item{case.sensitive}{a logical value. If \code{TRUE}, pattern-matching is case-sensitive.}

\item{show.results}{a logical value. If \code{TRUE}, results are printed after completion.}

\item{copy}{a logical value. If \code{TRUE}, all matching PDF files are copied to \code{folder}.}

\item{folder}{a character vector, path or name of new folder to copy matching PDF files scripts to.}

\item{overwrite}{a logical value. If \code{TRUE}, existing destination files are overwritten.}
}
\description{
\code{findPDF} scans all directories and subdirectories of a given path for PDF files (.pdf) containing
    a specific pattern.  Hits can be copied to a new folder.
}
\examples{
# Find all PDF files in the package folder that contain the name Hanna
findPDF(path = system.file(package = "findR"), pattern = "Hanna")

# Save results in a data frame and show hits
dt <- findPDF(path = system.file(package = "findR"), pattern = "Hanna", show.results = TRUE)
dt

}
