% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findRmd.R
\name{findRmd}
\alias{findRmd}
\title{Find R Markdown files by content with pattern matching}
\usage{
findRmd(path = ".", pattern = "Hello World", case.sensitive = TRUE,
  show.results = TRUE, copy = FALSE, folder = "findRmd",
  overwrite = TRUE)
}
\arguments{
\item{path}{a character vector, path to be scanned. The default corresponds to the working directory, getwd().}

\item{pattern}{a pattern (regular expression) to search for.}

\item{case.sensitive}{a logical value. If \code{TRUE}, pattern-matching is case-sensitive.}

\item{show.results}{a logical value. If \code{TRUE}, results are printed after completion.}

\item{copy}{a logical value. If \code{TRUE}, all matching R Markdown files are copied to \code{folder}.}

\item{folder}{a character vector, path or name of new folder to copy matching R Markdown files to.}

\item{overwrite}{a logical value. If \code{TRUE}, existing destination files are overwritten.}
}
\description{
\code{findRmd} scans all directories and subdirectories of a given path for R Markdown files (.Rmd) containing
    a specific pattern.  Hits can be copied to a new folder.
}
\examples{
# Find all R Markdown files in the package folder that contain a ggplot bar chart
findRmd(path = system.file(package = "findR"), pattern = "geom_bar")

# Save results in a data frame and show hits
dt <- findRmd(path = system.file(package = "findR"), pattern = "geom_bar", show.results = TRUE)
dt

}
