% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fishtree_phylogeny}
\alias{fishtree_phylogeny}
\title{Get a phylogeny from the Fish Tree of Life}
\usage{
fishtree_phylogeny(species, rank, type = c("chronogram", "phylogram"))
}
\arguments{
\item{species}{(Optionally) subset the results based on a vector of species names.}

\item{rank}{(Optionally) subset the results based on the supplied taxonomic rank.}

\item{type}{Either `"chronogram"` or `"phylogram"`. A chronogram has branch lengths proportional to units of time, while a phylogram has branch lengths proportional to the amount of character change.}
}
\value{
An object of class `"phylo"`.
}
\description{
Retrieves a phylogeny via the Fish Tree of Life API. If neither `species` nor `rank` are specified, returns the entire phylogeny.
}
\examples{
surgeons <- fishtree_phylogeny(rank = "Acanthuridae")

# Chronograms may not be ultrametric due to numerical precision issues
ape::is.ultrametric(surgeons)
ape::is.ultrametric(surgeons, tol = 0.00001)
}
\references{
Rabosky, D. L., Chang, J., Title, P. O., Cowman, P. F., Sallan, L., Friedman, M., Kashner, K., Garilao, C., Near, T. J., Coll, M., Alfaro, M. E. (2018). An inverse latitudinal gradient in speciation rate for marine fishes. Nature, 559(7714), 392–395. doi:10.1038/s41586-018-0273-1
}
\seealso{
\code{\link[ape]{read.tree}}, \code{\link[phytools]{force.ultrametric}}
}
