% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gbeta1.R
\name{EstMLEMcGBB}
\alias{EstMLEMcGBB}
\title{Estimating the shape parameters a,b and c for McDonald Generalized Beta Binomial
distribution}
\usage{
EstMLEMcGBB(x,freq,a,b,c)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{a}{single value for shape parameter alpha representing as a.}

\item{b}{single value for shape parameter beta representing as b.}

\item{c}{single value for shape parameter gamma representing as c.}
}
\value{
\code{EstMLEMcGBB} here is used as a input parameter for the \code{mle2} function of \pkg{bbmle}
package.
}
\description{
The function will estimate the shape parameters using the maximum log likelihood method  for
the McDonald Generalized Beta  Binomial distribution when the binomial random
variables and corresponding frequencies are given.
}
\details{
\deqn{0 < a,b,c}
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D=0:7                   #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
\dontrun{
parameters=suppressWarnings(bbmle::mle2(EstMLEMcGBB,start = list(a=0.1,b=0.1,c=0.2),
data = list(x=No.D.D,freq=Obs.fre.1)))

bbmle::coef(parameters)         #extracting the parameters
        }
}
\references{
Manoj, C., Wijekoon, P. & Yapa, R.D., 2013. The McDonald Generalized Beta-Binomial Distribution: A New
Binomial Mixture Distribution and Simulation Based Comparison with Its Nested Distributions in Handling
Overdispersion. International Journal of Statistics and Probability, 2(2), pp.24-41.

Available at: \url{http://www.ccsenet.org/journal/index.php/ijsp/article/view/23491}.

Janiffer, N.M., Islam, A. & Luke, O., 2014. Estimating Equations for Estimation of Mcdonald Generalized
Beta - Binomial Parameters. , (October), pp.702-709.

Roozegar, R., Tahmasebi, S. & Jafari, A.A., 2015. The McDonald Gompertz Distribution: Properties and Applications.
Communications in Statistics - Simulation and Computation, (May), pp.0-0.

Available at: \url{http://www.tandfonline.com/doi/full/10.1080/03610918.2015.1088024}.
}
\seealso{
\code{\link[bbmle]{mle2}}
}
