% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{fitGammaBin}
\alias{fitGammaBin}
\title{Fitting the Gamma Binomial distribution when binomial random variable,
frequency and shape parameters are given}
\usage{
fitGammaBin(x,obs.freq,c,l)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{obs.freq}{vector of frequencies.}

\item{c}{single value for shape parameter c.}

\item{l}{single value for shape parameter l.}
}
\value{
The output of \code{fitGammaBin} gives the class format \code{fitGaB} and \code{fit} consisting a list

\code{bin.ran.var} binomial random variables.

\code{obs.freq} corresponding observed frequencies.

\code{exp.freq} corresponding expected frequencies.

\code{statistic} chi-squared test statistics.

\code{df} degree of freedom.

\code{p.value} probability value by chi-squared test statistic.

\code{fitMB} fitted values of \code{dGammaBin}.

\code{NegLL} Negative Log Likelihood value.

\code{c} estimated value for shape parameter c.

\code{l} estimated value for shape parameter l.

\code{AIC} AIC value.

\code{over.dis.para} over dispersion value.

\code{call} the inputs of the function.

Methods \code{summary}, \code{print}, \code{AIC}, \code{residuals} and \code{fitted} can be used to
extract specific outputs.
}
\description{
The function will fit the Gamma Binomial Distribution when random variables,
corresponding frequencies and shape parameters are given. It will provide
the expected frequencies, chi-squared test statistics value, p value, degree of freedom
and over dispersion value so that it can be seen if this distribution fits the data.
}
\details{
\deqn{0 < c,l}
\deqn{x = 0,1,2,...}
\deqn{obs.freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D=0:7       #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)          #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters=suppressWarnings(bbmle::mle2(EstMLEGammaBin,start = list(c=0.1,l=0.1),
data = list(x=No.D.D,freq=Obs.fre.1)))

cGBin=bbmle::coef(parameters)[1]         #assigning the estimated c
lGBin=bbmle::coef(parameters)[2]         #assigning the estimated l

#fitting when the random variable,frequencies,shape parameter values are given.
results<-fitGammaBin(No.D.D,Obs.fre.1,cGBin,lGBin)
results

#extracting the expected frequencies
fitted(results)

#extracting the residuals
residuals(results)

}
\references{
Grassia, A., 1977. On a family of distributions with argument between 0 and 1
obtained by transformation of the gamma and derived compound distributions.
Australian Journal of Statistics, 19(2), pp.108-114.
}
