% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrBin.R
\name{EstMLECorrBin}
\alias{EstMLECorrBin}
\title{Estimating the probability of success and correlation for Correlated Binomial
Distribution}
\usage{
EstMLECorrBin(x,freq,p,cov,...)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{p}{single value for probability of success.}

\item{cov}{single value for covariance.}

\item{...}{mle2 function inputs except data and estimating parameter.}
}
\value{
\code{EstMLECorrBin} here is used as a wrapper for the \code{mle2} function of \pkg{bbmle} package
therefore output is of class of mle2.
}
\description{
The function will estimate the probability of success and correlation using the maximum log
likelihood method for the Correlated Binomial distribution when the binomial random
variables and corresponding frequencies are given.
}
\details{
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}
\deqn{0 < p < 1}
\deqn{-\infty < cov < +\infty}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7               #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)     #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLECorrBin(x=No.D.D,freq=Obs.fre.1,p=0.5,cov=0.0050)

bbmle::coef(parameters)           #extracting the parameters

}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate discrete distributions (Vol. 444).
Hoboken, NJ: Wiley-Interscience.

L. L. Kupper, J.K.H., 1978. The Use of a Correlated Binomial Model for the Analysis of Certain Toxicological
Experiments. Biometrics, 34(1), pp.69-76.

Paul, S.R., 1985. A three-parameter generalization of the binomial distribution. Communications in Statistics
- Theory and Methods, 14(6), pp.1497-1506.

Available at: \url{http://www.tandfonline.com/doi/abs/10.1080/03610928508828990} .

Jorge G. Morel and Nagaraj K. Neerchal. Overdispersion Models in SAS. SAS Institute, 2012.
}
\seealso{
\code{\link[bbmle]{mle2}}
}
