% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangle.R
\name{pTriBin}
\alias{pTriBin}
\title{Triangular Binomial Distribution}
\usage{
pTriBin(x,n,mode)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{n}{single value for no of binomial trials}

\item{mode}{single value for mode}
}
\value{
The output of \code{pTriBin} gives cumulative probability function values in vector form.
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the Triangular Binomial distribution.
}
\details{
Mixing unit bounded Triangular distribution with Binomial distribution will create
Triangular Binomial distribution. The probability function and cumulative probability function
can be constructed and are denoted below.

The cumulative probability function is the summation of probability function values.

\deqn{P_{TriBin}(x)= 2 {n \choose x}(c^{-1}B_c(x+2,n-x+1)+(1-c)^{-1}B(x+1,n-x+2)-(1-c)^{-1}B_c(x+1,n-x+2))}
\deqn{0 < mode=c < 1}
\deqn{x = 0,1,2,...n}
\deqn{n = 1,2,3...}

The mean, variance and over dispersion are denoted as
\deqn{E_{TriiBin}[x]= \frac{n(1+c)}{3} }
\deqn{Var_{TriBin}[x]= \frac{n(n+3)}{18}-\frac{n(n-3)c(1-c)}{18} }
\deqn{over dispersion= \frac{(1-c+c^2)}{2(2+c-c^2)} }

Defined as \eqn{B_c(a,b)=\int^c_0 t^{a-1} (1-t)^{b-1} \,dt} is incomplete beta integrals
and \eqn{B(a,b)} is the beta function.

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col <- rainbow(7)
x <- seq(0.1,0.7,by=0.1)
plot(0,0,main="Triangular binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,.3))
for (i in 1:7)
{
lines(0:10,dTriBin(0:10,10,x[i])$pdf,col = col[i],lwd=2.85)
points(0:10,dTriBin(0:10,10,x[i])$pdf,col = col[i],pch=16)
}

dTriBin(0:10,10,.4)$pdf        #extracting the pdf values
dTriBin(0:10,10,.4)$mean       #extracting the mean
dTriBin(0:10,10,.4)$var        #extracting the variance
dTriBin(0:10,10,.4)$over.dis.para  #extracting the over dispersion value

#plotting the random variables and cumulative probability values
col <- rainbow(7)
x <- seq(0.1,0.7,by=0.1)
plot(0,0,main="Triangular binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,1))
for (i in 1:7)
{
lines(0:10,pTriBin(0:10,10,x[i]),col = col[i],lwd=2.85)
points(0:10,pTriBin(0:10,10,x[i]),col = col[i],pch=16)
}

pTriBin(0:10,10,.4)    #acquiring the cumulative probability values

}
\references{
Horsnell, G. (1957). Economic acceptance sampling schemes. Journal of the Royal Statistical Society,
Series A, 120:148-191.

Karlis, D. & Xekalaki, E., 2008. The Polygonal Distribution. In Advances in Mathematical and Statistical
Modeling. Boston: Birkhuser Boston, pp. 21-33.

Available at: \url{http://dx.doi.org/10.1007/978-0-8176-4626-4_2}.

Okagbue, H. et al., 2014. Using the Average of the Extreme Values of a Triangular Distribution for a
Transformation, and Its Approximant via the Continuous Uniform Distribution. British Journal of Mathematics
& Computer Science, 4(24), pp.3497-3507.

Available at: \url{http://www.sciencedomain.org/abstract.php?iid=699&id=6&aid=6427}.
}
