% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_albert.R
\docType{data}
\name{fifa_audience}
\alias{fifa_audience}
\title{How To Break FIFA}
\format{A data frame with 3652 rows representing guests and 6 variables:
\describe{
  \item{country}{FIFA member country}
  \item{confederation}{Confederation to which country belongs}
  \item{population_share}{Country's share of global population (percentage)}
  \item{tv_audience_share}{Country's share of global world cup TV Audience (percentage)}
  \item{gdp_weighted_share}{Country's GDP-weighted audience share (percentage)}
}}
\source{
See \url{https://github.com/fivethirtyeight/data/tree/master/fifa}
}
\usage{
fifa_audience
}
\description{
The raw data behind the story
"How To Break FIFA"
\url{https://fivethirtyeight.com/features/how-to-break-fifa/}.
}
\examples{
# To convert data frame to tidy data (long) format, run:
library(dplyr)
library(tidyr)
library(stringr)
fifa_audience_tidy <- fifa_audience \%>\%
  gather(type, share, -c(country, confederation)) \%>\%
  mutate(type = str_sub(type, start=1, end=-7)) \%>\%
  arrange(country)
}
\keyword{datasets}
