% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_jen.R
\docType{data}
\name{riddler_castles}
\alias{riddler_castles}
\title{Can You Rule Riddler Nation?}
\format{A data frame with 1387 rows representing submissions and 11 variables:
\describe{
  \item{castle1}{Number of troops out of 100 send to castle 1}
  \item{castle2}{Number of troops out of 100 send to castle 2}
  \item{castle3}{Number of troops out of 100 send to castle 3}
  \item{castle4}{Number of troops out of 100 send to castle 4}
  \item{castle5}{Number of troops out of 100 send to castle 5}
  \item{castle6}{Number of troops out of 100 send to castle 6}
  \item{castle7}{Number of troops out of 100 send to castle 7}
  \item{castle8}{Number of troops out of 100 send to castle 8}
  \item{castle9}{Number of troops out of 100 send to castle 9}
  \item{castle10}{Number of troops out of 100 send to castle 10}
  \item{reason}{Why did you choose your troop deployment?}
}}
\source{
See \url{https://github.com/fivethirtyeight/data/tree/master/riddler-castles}
}
\usage{
riddler_castles
}
\description{
The raw data behind the story
"Can You Rule Riddler Nation?"
\url{https://fivethirtyeight.com/features/can-you-rule-riddler-nation/}.
Analysis of the submitted solutions can be found at: \url{https://fivethirtyeight.com/features/can-you-save-the-drowning-swimmer/}
}
\examples{
# To convert data frame to tidy data (long) format, run
library(dplyr)
library(tidyr)
library(stringr)
riddler_castles_tidy<-riddler_castles \%>\%
   gather(key = castle , value = soldiers, castle1:castle10) \%>\%
   mutate(castle = as.numeric(str_replace(castle, "castle","")))
}
\seealso{
\code{\link{riddler_castles2}}
}
\keyword{datasets}
