% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_row_names.R
\name{fix_row_names}
\alias{fix_row_names}
\title{Fix row names of a data frame}
\usage{
fix_row_names(data)
}
\arguments{
\item{data}{a data frame with improperly formatted row names}
}
\value{
a modified data frame with fixed row names
}
\description{
This function removes any leading "X." or "X" from the row names of a data frame, replaces any "." with "_", removes any leading or trailing symbols and spaces, and ensures that there is only one underscore between two words. Additionally, if there are duplicate row names, the function appends a number to each duplicate row name to make it unique.
}
\examples{
my_data <- data.frame(" Col1" = c(1, 2, 3), "Col.2" = c(4, 5, 6), check.names = FALSE)
rownames(my_data) <- c(" Row1", " Row.2", "Row.3 ")
fix_row_names(my_data)

}
