% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_excel.R
\name{read_excel_sheet}
\alias{read_excel_sheet}
\title{Import Excel file sheet}
\usage{
read_excel_sheet(
  file,
  sheetIndex = 1,
  sheetName = NULL,
  define_page = 3,
  page_sep = ":"
)
}
\arguments{
\item{file}{A string, name of an Excel file.}

\item{sheetIndex}{A number, sheet index in the workbook.}

\item{sheetName}{A string, sheet name.}

\item{define_page}{A integer, 0: no page, 1: file name as page, 2: sheet name
as page, 3: file and sheet names as page, separated by the indicated separator.}

\item{page_sep}{A string, separator to form the page value.}
}
\value{
A \code{pivot_table} object.
}
\description{
Reads an Excel file sheet and creates a \code{pivot_table} object. The sheet is
expected to contain one or more pivot tables. Each line in the sheet
corresponds to a row in a table. The file and sheet names can be included as
part of the object attributes.
}
\details{
When multiple files or sheets are handled, the file and/or sheet names may
contain information associated with the pivot table, they could be the table
page information. In order not to lose this information, they can be stored
in the \code{pivot_table} object.
}
\examples{

# file <- system.file("extdata", "excelfolder/m4.xlsx", package = "flattabler")
# pt <- read_excel_sheet(file)

# pt <- read_excel_sheet(file, sheetName = "Hoja2", define_page = 1)

}
\seealso{
\code{\link{pivot_table}}

Other import functions: 
\code{\link{read_excel_file}()},
\code{\link{read_excel_folder}()},
\code{\link{read_text_file}()},
\code{\link{read_text_folder}()}
}
\concept{import functions}
