% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_findPath}
\alias{fxml_findPath}
\title{Finding XML elements}
\usage{
fxml_findPath(xmlflat.df, path, attr.only = NULL, attr.not = NULL)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{path}{A character vector representing the path to be searched. Each element of the vector is a hierarchy level in the XML document. Example: \code{path = c("tag1", "tag2")}.}

\item{attr.only}{A list of named vectors representing attribute/value combinations the XML elements on the search path must match.
The name of an element in the list is the XML elment name to which the attribute belongs. The list element itself is a named vector.
The vector's elements represent different attributes (= the names of the vector elements) and their values (= vector elements).
Example: \code{attr.only = list(tag1 = c(attrib1 = "Value 1", attrib2 = "Value 2"), tag2 = c(attrib3 = "Value 3"))} will only find those elements which lie on a
path that includes \code{<tag1 attrib1 = "Value 1" attrib2 = "Value 2"><tag2 attrib3 = "Value 3">}.}

\item{attr.not}{A list of vectors representing attribute/value combinations the XML elements on the search path must not match to be included in the results. See argument \code{attr.only} for details on the composition.}
}
\value{
The IDs (\code{xmlflat.df$elemid.}) of the XML elements that are located on the provided path. Sub-elements of the elements on the search path are returned, too. \code{NULL}, if no elements where found.
}
\description{
Finds all XML elements in an XML document that lie on a certain path, regardless of where exactly the path is found in the XML document. Sub-elements (children) of the elements on the search path are returned, too.
}
\details{
With \code{fxml_findPath()} it does not matter where exactly in the hierarchy of the XML document the path is found. If, for example, \code{path = c("tag1", "tag2")} then
the element with full XML path \code{<xml><testdoc><tag1><tag2>} would be found, too.

Other \code{fxml_findPath...()} functions allow for different search modes:
\itemize{
\item \code{\link{fxml_findPathRoot}}: Search for path from the root node of the XML document downwards. Sub-elements are returned, too.
\item \code{\link{fxml_findPathFull}}: Search for exact path (always starting from the root node). No sub-elements returned, as they have a different path than the search path.
\item \code{\link{fxml_findPathBottom}}: Search for path from the bottom of the element hierarchy in the XML document.
}
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Find all XML elements with <data><record><field> in their XML path
path <- c("data", "record", "field")
fxml_findPath(xml.dataframe, path)

# Find only those XML elements with <data><record><field> in their XML path that have the
# "name" attribute of the <field> element set to "Sex"
path <- c("data", "record", "field")
fxml_findPath(xml.dataframe, path, attr.only = list(field = c(name = "Sex")))
}
\seealso{
\code{\link{fxml_findPathRoot}}, \code{\link{fxml_findPathFull}}, \code{\link{fxml_findPathBottom}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
