% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_logistic}
\alias{fn_logistic}
\title{Logistic function}
\usage{
fn_logistic(t, L, k, t0)
}
\arguments{
\item{t}{Numeric value.}

\item{L}{Numeric value.}

\item{k}{Numeric value.}

\item{t0}{Numeric value.}
}
\value{
A numeric value based on the logistic function.
}
\description{
Computes a value based on a logistic function.
}
\details{
\if{html}{
\deqn{
f(t; L, k, t0) = \frac{L}{1 + e^{-k(t - t_0)}}
}
}
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_logistic",
  params = c(L = 100, k = 0.199, t0 = 47.7),
  interval = c(0, 108),
  n_points = 2000
)
}
