% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exp.R, R/Gamma.R, R/GenF.R, R/GenGamma.R,
%   R/Gompertz.R, R/Lnorm.R, R/Weibull.R, R/flexsurv-package.R
\name{mean_exp}
\alias{mean_exp}
\alias{rmst_exp}
\alias{mean_gamma}
\alias{rmst_gamma}
\alias{rmst_genf}
\alias{mean_genf}
\alias{rmst_genf.orig}
\alias{mean_genf.orig}
\alias{rmst_gengamma}
\alias{mean_gengamma}
\alias{rmst_gengamma.orig}
\alias{mean_gengamma.orig}
\alias{rmst_gompertz}
\alias{mean_gompertz}
\alias{mean_lnorm}
\alias{rmst_lnorm}
\alias{mean_weibull}
\alias{rmst_weibull}
\alias{means}
\alias{mean_weibullPH}
\alias{rmst_weibullPH}
\alias{mean_llogis}
\alias{rmst_llogis}
\title{Mean and restricted mean survival functions}
\usage{
mean_exp(rate = 1)

rmst_exp(t, rate = 1, start = 0)

mean_gamma(shape, rate = 1)

rmst_gamma(t, shape, rate = 1, start = 0)

rmst_genf(t, mu, sigma, Q, P, start = 0)

mean_genf(mu, sigma, Q, P)

rmst_genf.orig(t, mu, sigma, s1, s2, start = 0)

mean_genf.orig(mu, sigma, s1, s2)

rmst_gengamma(t, mu = 0, sigma = 1, Q, start = 0)

mean_gengamma(mu = 0, sigma = 1, Q)

rmst_gengamma.orig(t, shape, scale = 1, k, start = 0)

mean_gengamma.orig(shape, scale = 1, k)

rmst_gompertz(t, shape, rate = 1, start = 0)

mean_gompertz(shape, rate = 1)

mean_lnorm(meanlog = 0, sdlog = 1)

rmst_lnorm(t, meanlog = 0, sdlog = 1, start = 0)

mean_weibull(shape, scale = 1)

rmst_weibull(t, shape, scale = 1, start = 0)
}
\arguments{
\item{rate}{Rate parameter (exponential and gamma)}

\item{t}{Vector of times to which restricted mean survival time is evaluated}

\item{start}{Optional left-truncation time or times.  The returned
restricted mean survival will be conditioned on survival up to
this time.}

\item{shape}{Shape parameter (Weibull, gamma, log-logistic, generalized gamma [orig],
generalized F [orig])}

\item{mu}{Mean on the log scale (generalized gamma, generalized F)}

\item{sigma}{Standard deviation on the log scale (generalized gamma, generalized F)}

\item{Q}{Vector of first shape parameters (generalized gamma, generalized F)}

\item{P}{Vector of second shape parameters (generalized F)}

\item{s1}{Vector of first F shape parameters (generalized F [orig])}

\item{s2}{vector of second F shape parameters (generalized F [orig])}

\item{scale}{Scale parameter (Weibull, log-logistic, generalized gamma [orig],
generalized F [orig])}

\item{k}{vector of shape parameters (generalized gamma [orig]).}

\item{meanlog}{Mean on the log scale (log normal)}

\item{sdlog}{Standard deviation on the log scale (log normal)}
}
\value{
mean survival (functions beginning 'mean') or restricted mean survival
(functions beginning 'rmst_').
}
\description{
Mean and restricted mean survival time functions for distributions which are built
into flexsurv.
}
\details{
For the exponential, Weibull, log-logistic, lognormal, and gamma, mean survival is
provided analytically.  Restricted mean survival for the exponential distribution
is also provided analytically.  Mean and restricted means for other distributions
are calculated via numeric integration.
}
\seealso{
\code{\link{dexp}},\code{\link{dweibull}},\code{\link{dgamma}},\code{\link{dlnorm}},\code{\link{dgompertz}},\code{\link{dgengamma}},\code{\link{dgenf}}
}
\author{
Christopher Jackson <chris.jackson@mrc-bsu.cam.ac.uk>
}
\keyword{distribution}
