% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R, R/regulartable.R
\name{flextable}
\alias{flextable}
\alias{print.flextable}
\alias{regulartable}
\title{flextable creation}
\usage{
flextable(data, col_keys = names(data), cwidth = 0.75, cheight = 0.25)

\method{print}{flextable}(x, preview = "html", ...)

regulartable(data, col_keys = names(data), cwidth = 0.75, cheight = 0.25)
}
\arguments{
\item{data}{dataset}

\item{col_keys}{columns names/keys to display. If some column names are not in
the dataset, they will be added as blank columns by default.}

\item{cwidth, cheight}{initial width and height to use for cell sizes.}

\item{x}{flextable object}

\item{preview}{preview type, one of c("html", "pptx", "docx").}

\item{...}{unused argument}
}
\description{
Create a flextable object with function \code{flextable}.

\code{flextable} are designed to make tabular reporting easier for
R users. Functions are available to let you format text, paragraphs and cells;
table cells can be merge vertically or horizontally, row headers can easilly
be defined, rows heights and columns widths can be manually set or automatically
computed.
}
\details{
A \code{flextable} is made of 2 parts: header and body.

Most functions have an argument named \code{part} that will be used
to specify what part of of the table should be modified.
}
\examples{
ft <- flextable(mtcars)
ft
}
