% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_lgl}
\alias{colformat_lgl}
\alias{colformat_lgl.flextable}
\title{format logical cells}
\usage{
colformat_lgl(x, ...)

\method{colformat_lgl}{flextable}(
  x,
  j = NULL,
  col_keys = NULL,
  true = "true",
  false = "false",
  na_str = "",
  prefix = "",
  suffix = "",
  ...
)
}
\arguments{
\item{x}{a flextable object}

\item{...}{additional arguments, i can be used to specify a
row selector.}

\item{j}{columns selection.}

\item{col_keys}{names of the colkeys. Will be deprectated in favor of j in the next
version.}

\item{false, true}{string to be used for logical}

\item{na_str}{string to be used for NA values}

\item{prefix}{string to be used as prefix or suffix}

\item{suffix}{string to be used as prefix or suffix}
}
\description{
Format logical cells in a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_colformat_lgl_1.png}{options: width=20\%}}
}

\examples{
dat <- data.frame(a = c(TRUE, FALSE), b = c(FALSE, TRUE))

ft <- flextable(dat)
ft <- colformat_lgl(x = ft, j = c("a", "b"))
autofit(ft)
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_int}()},
\code{\link{colformat_num}()},
\code{\link{compose}()}
}
\concept{cells formatters}
