% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{footnote}
\alias{footnote}
\title{add footnotes to flextable}
\usage{
footnote(x, i = NULL, j = NULL, value, ref_symbols = NULL,
  part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{column selection}

\item{value}{a call to function \code{\link{as_paragraph}}.}

\item{ref_symbols}{character value, symbols to append that will be used
as references to notes.}

\item{part}{partname of the table (one of 'body', 'header', 'footer')}
}
\description{
add footnotes to a flextable object. A symbol is appened
where the footnote is defined and the note is appened in the footer part
of the table.
}
\examples{
ft <- flextable(head(iris))
ft <- footnote( ft, i = 1, j = 1:3,
            value = as_paragraph(
              c("This is footnote one",
                "This is footnote two",
                "This is footnote three")
            ),
            ref_symbols = c("a", "b", "c"),
            part = "header")
ft <- valign(ft, valign = "bottom", part = "header")
\donttest{ft <- autofit(ft)}
}
