% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-slopes0_temp.R
\docType{data}
\name{slopes0_temp}
\alias{slopes0_temp}
\title{Slopes for each flux}
\format{
A tibble with 1251 rows and 29 variables
\describe{
\item{datetime}{Datetime at which CO2 concentration was recorded.}
\item{temp_air}{Air temperature inside the flux chamber in Celsius.}
\item{temp_soil}{Ground temperature inside the flux chamber in Celsius.}
\item{conc}{CO2 concentration in ppm.}
\item{PAR}{Photosynthetically active radiation inside the chamber
in micromol/s/sqm.}
\item{turfID}{Unique ID of the turf in which the measurement took place.}
\item{type}{Type of measurement: ecosystems respiration (ER)
or net ecosystem exchange (NEE).}
\item{f_start}{Datetime at which the measurement was started.}
\item{f_end}{Datetime at which the measurement ended.}
\item{f_fluxid}{Unique ID for each flux.}
\item{f_ratio}{Ratio of number of datapoints over length of measurement
in seconds.}
\item{f_flag_match}{Flags from flux_match.}
\item{f_time}{Time variable of the flux in seconds.}
\item{f_cut}{Indicating if the measurement should be kept (keep)
or discarded (cut).}
\item{f_Cz}{Cz parameter of the C(t) function.}
\item{f_Cm}{Cm parameter of the C(t) function, calculated by optim() with
Cm_est as starting point.}
\item{f_a}{a parameter of the C(t) function, calculated by optim() with
a_est as starting point.}
\item{f_b}{b parameter of the C(t) function, calculated by optim() with
b_est as starting point.}
\item{f_tz}{tz parameter of the C(t) function, calculated by optim() with
tz_est as starting point.}
\item{f_slope}{Slope of C(t) at tz}
\item{f_fit}{C(t), modeled CO2 concentration as a function of time.}
\item{f_fit_slope}{Output of linear model of CO2 concentration passing by
C(tz) and a slope of slope_tz.}
\item{f_start_z}{Datetime format of tz}
\item{f_cor_coef}{Correlation coefficient of concentration over time.}
\item{f_RMSE}{RMSE of the fit.}
\item{f_quality_flag}{Quality flags according to flux_quality.}
\item{f_slope_corr}{Slope as advised by quality flags.}
\item{temp_fahr}{Air temperature inside the flux chamber in Fahrenheit
averaged over the flux measurement.}
\item{temp_kelvin}{Air temperature inside the flux chamber in Kelvin
averaged over the flux measurement.}
}
}
\usage{
slopes0_temp
}
\description{
Slopes of C(t) for each flux with air temperature in various units.
}
\examples{
slopes0_temp
}
\keyword{internal}
