% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-methods.R
\name{tz}
\alias{tz}
\alias{tz.Calendar}
\alias{tz.JointCalendar}
\title{Extract time zone from calendars}
\usage{
\method{tz}{Calendar}(x)

\method{tz}{JointCalendar}(x)
}
\arguments{
\item{x}{an instance of a \code{\link{Calendar}} or \code{\link{JointCalendar}} object}
}
\value{
a string representing the time zone (e.g. "Australia/Sydney") or
vector of time zones in the case of joint calendars
}
\description{
Extract time zone from calendars
}
\examples{
lubridate::tz(AUSYCalendar())
lubridate::tz(c(AUSYCalendar(), AUMECalendar()))
}
\seealso{
Other calendar methods: \code{\link{adjust}},
  \code{\link{generate_schedule}}, \code{\link{is_good}},
  \code{\link{is_valid_bdc}}, \code{\link{is}},
  \code{\link{locale}}, \code{\link{shift}}
}
