% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastpowermds.R
\name{fastpowermds}
\alias{fastpowermds}
\title{Power Multidimensional Scaling Function}
\usage{
fastpowermds(
  delta,
  w = NULL,
  p = 2,
  z = NULL,
  r = NULL,
  b = NULL,
  MAXITER = 1024,
  FCRIT = 1e-08,
  ZCRIT = 1e-06,
  rotate = TRUE,
  faster = FALSE,
  error.check = FALSE,
  echo = FALSE
)
}
\arguments{
\item{delta}{an n by n squares hollow matrix containing dissimilarities.}

\item{w}{an identical sized matrix containing non-negative weights (all ones when omitted).}

\item{p}{dimensionality (default = 2).}

\item{z}{n by p matrix with initial coordinates.}

\item{r}{restrictions on the configuration,
either an n by p matrix with booleans indicating free (false) and fixed (true) coordinates
or an n by h numerical matrix with h independent variables.}

\item{b}{h by p matrix with initial regression coefficients.}

\item{MAXITER}{maximum number of iterations (default = 1024).}

\item{FCRIT}{relative convergence criterion function value (default = 0.00000001).}

\item{ZCRIT}{absolute convergence criterion coordinates (default = 0.000001).}

\item{rotate}{if TRUE: solution is rotated to principal axes.}

\item{faster}{logical indicating faster but less precise procedure}

\item{error.check}{extensive validity check input parameters (default = FALSE).}

\item{echo}{print intermediate algorithm results (default = FALSE).}
}
\value{
data original n by n matrix with dissimilarities.

weights original n by n matrix with weights.

transformed.data final n by n matrix with transformed dissimilarities.

coordinates final n by p matrix with coordinates.

restriction either the fixed coordinates or the independent variables.

coefficients final h by p matrix with regression coefficients.

distances final n by n matrix with Euclidean distances between n rows of coordinates.

last.iteration final iteration number.

last.difference final function difference used for convergence testing.

n.stress final normalized stress value.

rotate if solution is rotated to principal axes.

faster if a faster procedure has been used.
}
\description{
\code{fastpowermds} performs power multidimensional scaling.
The function follows algorithms given by de Leeuw and Heiser (1980).
The data, dissimilarities and weights, are either symmetric or asymmetric.
The dissimilarities are may contain negative values, the weights may not.
The configuration is either unrestricted, (partly) fixed, or a linear combination of independent variables.
The dissimilarities are optimally power transformed.
}
\examples{
data( "colors" )
delta <- as.matrix( colors^3 )
n <- nrow( delta )
w <- 1 - diag( n )
p <- 2
zinit <- matrix( runif( n * p ), n, p )
r <- fastpowermds( delta, w, p, z = zinit, echo = TRUE )
summary( r )
print( r )
plot( r )

}
\references{
de Leeuw, J., and Heiser, W. J. (1980). Multidimensional scaling with restrictions on the configuration.
            In P.R. Krishnaiah (Ed.), Multivariate analysis (Vol. 5, pp. 501–522).
            Amsterdam, The Netherlands: North-Holland Publishing Company.

            Heiser, W.J. (1991). A generalized majorization method for least squares multidimensional scaling of pseudo-distances that may be negative.
            Psychometrika, 55, pages 7-27.

            Busing, F.M.T.A. (submitted). Node Localization by Multidimensional Scaling with Iterative Majorization: A Psychometric Perspective.
            Signal Processing, Elsevier.
}
\author{
Frank M.T.A. Busing
}
