% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{common.predict}
\alias{common.predict}
\title{Forecasting the factor-driven common component}
\usage{
common.predict(object, x, h = 1, fc.restricted = TRUE, r = c("ic", "er"))
}
\arguments{
\item{object}{\code{fnets} object}

\item{x}{input time series matrix, with each row representing a variable}

\item{h}{forecasting horizon}

\item{fc.restricted}{whether to forecast using a restricted or unrestricted, blockwise VAR representation of the common component}

\item{r}{number of restricted factors, or a string specifying the factor number selection method when \code{fc.restricted = TRUE};
 possible values are:
\itemize{
   \item{\code{"ic"}}{ information criteria of Bai and Ng (2002)}
   \item{\code{"er"}}{ eigenvalue ratio}
}}
}
\value{
a list containing
\item{is}{ in-sample estimator of the common component}
\item{fc}{ forecasts of the common component for a given forecasting horizon \code{h}}
\item{r}{ restricted factor number}
\item{h}{ forecast horizon}
}
\description{
Produces forecasts of the common component
for a given forecasting horizon by estimating the best linear predictors
}
\examples{
set.seed(123)
n <- 500
p <- 50
common <- sim.unrestricted(n, p)
idio <- sim.var(n, p)
x <- common$data + idio$data
out <- fnets(x, q = NULL, var.order = 1, var.method = "lasso",
do.lrpc = FALSE, var.args = list(n.cores = 2))
cpre <- common.predict(out, x, h = 1, r = NULL)
ipre <- idio.predict(out, x, cpre, h = 1)
}
\references{
Ahn, S. C. & Horenstein, A. R. (2013) Eigenvalue ratio test for the number of factors. Econometrica, 81(3), 1203--1227.

Barigozzi, M., Cho, H. & Owens, D. (2022) FNETS: Factor-adjusted network estimation and forecasting for high-dimensional time series. arXiv preprint arXiv:2201.06110.

Forni, M., Hallin, M., Lippi, M. & Reichlin, L. (2005). The generalized dynamic factor model: one-sided estimation and forecasting. Journal of the American Statistical Association, 100(471), 830--840.

Forni, M., Hallin, M., Lippi, M. & Zaffaroni, P. (2017). Dynamic factor models with infinite-dimensional factor space: Asymptotic analysis. Journal of Econometrics, 199(1), 74--92.

Owens, D., Cho, H. & Barigozzi, M. (2022) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling. arXiv preprint arXiv:2301.11675.
}
