% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idio.R
\name{threshold}
\alias{threshold}
\title{Edge selection for VAR parameter, inverse innovation covariance, and long-run partial correlation matrices}
\usage{
threshold(mat, path.length = 500, do.plot = FALSE)
}
\arguments{
\item{mat}{input parameter matrix}

\item{path.length}{number of candidate thresholds}

\item{do.plot}{whether to plot thresholding output}
}
\value{
a list which contains the following fields:
\item{threshold}{ data-driven threshold}
\item{thr.mat}{ thresholded input matrix}
}
\description{
Threshold the entries of the input matrix at a data-driven level to perform edge selection
}
\details{
See Liu, Zhang, and Liu (2021) for more information on the threshold selection process
}
\examples{
\donttest{
set.seed(123)
A <- diag(.7, 50) + rnorm(50^2, 0, .1)
threshold.A <- threshold(A)
}
}
\references{
Barigozzi, M., Cho, H. & Owens, D. (2022) FNETS: Factor-adjusted network analysis for high-dimensional time series. arXiv preprint arXiv:2201.06110.

Liu, B., Zhang, X. & Liu, Y. (2021) Simultaneous Change Point Inference and Structure Recovery for High Dimensional Gaussian Graphical Models. Journal of Machine Learning Research, 22(274), 1--62.

Owens, D., Cho, H. & Barigozzi, M. (2022) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling. arXiv preprint arXiv:2301.11675.
}
