% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forwardSel.R
\name{getBestVar}
\alias{getBestVar}
\title{Select Best Variable at Current Step Based on Multivariate Test Statistics}
\usage{
getBestVar(currentVar, newVar, Sw, St, testStat = "Pillai")
}
\arguments{
\item{currentVar}{A numeric vector indicating the indices of currently
selected variables.}

\item{newVar}{A numeric vector indicating the indices of candidate variables
to be tested.}

\item{Sw}{A matrix representing the within-class scatter matrix.}

\item{St}{A matrix representing the total scatter matrix.}

\item{testStat}{A character string specifying the test statistic to use. Can
be either \code{"Pillai"} or \code{"Wilks"}. Default is \code{"Pillai"}.}
}
\value{
A list containing: \item{stopflag}{A logical value indicating whether
the best variable is collinear (i.e., should the selection stop).}
\item{varIdx}{The index of the selected variable from \code{newVar} based on the
test statistic.} \item{stat}{The value of the test statistic for the
selected variable.} \item{collinearVar}{A vector of indices from \code{newVar}
representing collinear variables.}
}
\description{
This function selects the best variable based on the specified multivariate
test statistic (\code{Pillai} or \code{Wilks}). It evaluates the statistic for each
candidate variable in \code{newVar} when combined with \code{currentVar}, and returns
the index and test statistic of the best variable. It also identifies
collinear variables.
}
