% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c.R
\name{fct_c}
\alias{fct_c}
\title{Concatenate factors, combining levels}
\usage{
fct_c(fs, ...)
}
\arguments{
\item{fs}{A factor, or list of factors.}

\item{...}{Individual factors}
}
\description{
This is useful way of patching together factors from multiple sources
that really should have the same levels but don't.
}
\examples{
fa <- factor("a")
fb <- factor("b")
fab <- factor(c("a", "b"))

c(fa, fb, fab)
fct_c(fa, fb, fab)

# You can also pass a list of factors as the first argument
fs <- list(fa, fb, fab)
fct_c(fs)
}
