% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{forecast.lm}
\alias{forecast.lm}
\title{Forecast a linear model with possible time series components}
\usage{
\method{forecast}{lm}(object, newdata, h = 10, level = c(80, 95),
  fan = FALSE, lambda = object$lambda, biasadj = NULL, ts = TRUE, ...)
}
\arguments{
\item{object}{Object of class "lm", usually the result of a call to
\code{\link[stats]{lm}} or \code{\link{tslm}}.}

\item{newdata}{An optional data frame in which to look for variables with
which to predict. If omitted, it is assumed that the only variables are
trend and season, and \code{h} forecasts are produced.}

\item{h}{Number of periods for forecasting. Ignored if \code{newdata}
present.}

\item{level}{Confidence level for prediction intervals.}

\item{fan}{If \code{TRUE}, level is set to seq(51,99,by=3). This is suitable
for fan plots.}

\item{lambda}{Box-Cox transformation parameter. Ignored if \code{NULL}.
Otherwise, forecasts back-transformed via an inverse Box-Cox transformation.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If TRUE, point forecasts and fitted values are mean
forecast. Otherwise, these points can be considered the median of the
forecast densities.}

\item{ts}{If \code{TRUE}, the forecasts will be treated as time series
provided the original data is a time series; the \code{newdata} will be
interpreted as related to the subsequent time periods. If \code{FALSE}, any
time series attributes of the original data will be ignored.}

\item{...}{Other arguments passed to \code{\link[stats]{predict.lm}()}.}
}
\value{
An object of class "\code{forecast}".

The function \code{summary} is used to obtain and print a summary of the
results, while the function \code{plot} produces a plot of the forecasts and
prediction intervals.

The generic accessor functions \code{fitted.values} and \code{residuals}
extract useful features of the value returned by \code{forecast.lm}.

An object of class \code{"forecast"} is a list containing at least the
following elements: \item{model}{A list containing information about the
fitted model} \item{method}{The name of the forecasting method as a
character string} \item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals} \item{upper}{Upper
limits for prediction intervals} \item{level}{The confidence values
associated with the prediction intervals} \item{x}{The historical data for
the response variable.} \item{residuals}{Residuals from the fitted model.
That is x minus fitted values.} \item{fitted}{Fitted values}
}
\description{
\code{forecast.lm} is used to predict linear models, especially those
involving trend and seasonality components.
}
\details{
\code{forecast.lm} is largely a wrapper for
\code{\link[stats]{predict.lm}()} except that it allows variables "trend"
and "season" which are created on the fly from the time series
characteristics of the data. Also, the output is reformatted into a
\code{forecast} object.
}
\examples{

y <- ts(rnorm(120,0,3) + 1:120 + 20*sin(2*pi*(1:120)/12), frequency=12)
fit <- tslm(y ~ trend + season)
plot(forecast(fit, h=20))

}
\seealso{
\code{\link{tslm}}, \code{\link[stats]{lm}}.
}
\author{
Rob J Hyndman
}
\keyword{stats}
