% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R, R/graph.R
\name{ggtsdisplay}
\alias{ggtsdisplay}
\alias{tsdisplay}
\title{Time series display}
\usage{
ggtsdisplay(x, plot.type = c("partial", "histogram", "scatter",
  "spectrum"), points = TRUE, smooth = FALSE, lag.max,
  na.action = na.contiguous, theme = NULL, ...)

tsdisplay(x, plot.type = c("partial", "histogram", "scatter",
  "spectrum"), points = TRUE, ci.type = c("white", "ma"), lag.max,
  na.action = na.contiguous, main = NULL, xlab = "", ylab = "",
  pch = 1, cex = 0.5, ...)
}
\arguments{
\item{x}{a numeric vector or time series of class \code{ts}.}

\item{plot.type}{type of plot to include in lower right corner.}

\item{points}{logical flag indicating whether to show the individual points
or not in the time plot.}

\item{smooth}{logical flag indicating whether to show a smooth loess curve
superimposed on the time plot.}

\item{lag.max}{the maximum lag to plot for the acf and pacf. A suitable
value is selected by default if the argument is missing.}

\item{na.action}{function to handle missing values in acf, pacf and spectrum
calculations. The default is \code{\link[stats]{na.contiguous}}. Useful
alternatives are \code{\link[stats]{na.pass}} and \code{\link{na.interp}}.}

\item{theme}{Adds a ggplot element to each plot, typically a theme.}

\item{\dots}{additional arguments to \code{\link[stats]{acf}}.}

\item{ci.type}{type of confidence limits for ACF that is passed to
\code{\link[stats]{acf}}. Should the confidence limits assume a white noise
input or for lag \eqn{k} an MA(\eqn{k-1}) input?}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{pch}{Plotting character.}

\item{cex}{Character size.}
}
\value{
None.
}
\description{
Plots a time series along with its acf and either its pacf, lagged
scatterplot or spectrum.
}
\details{
\code{ggtsdisplay} will produce the equivalent plot using ggplot graphics.
}
\examples{
library(ggplot2)
ggtsdisplay(USAccDeaths, plot.type="scatter", theme=theme_bw())

tsdisplay(diff(WWWusage))
ggtsdisplay(USAccDeaths, plot.type="scatter")

}
\references{
Hyndman and Athanasopoulos (2018) \emph{Forecasting: principles
and practice}, 2nd edition, OTexts: Melbourne, Australia.
\url{https://OTexts.org/fpp2/}
}
\seealso{
\code{\link[stats]{plot.ts}}, \code{\link{Acf}},
\code{\link[stats]{spec.ar}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
