% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strs.R
\name{strs}
\alias{strs}
\title{Stratified Random Sampling}
\usage{
strs(df, Yi, plot_area, strata_area, strata, .groups = NA, age = NA,
  alpha = 0.05, error = 10, dec_places = 4, pop = "inf",
  tidy = TRUE)
}
\arguments{
\item{df}{a data frame.}

\item{Yi}{Quoted name of the volume variable, or other variable one desires to evaluate, in quotes.}

\item{plot_area}{Quoted name of the plot area variable, or a numeric vector with the plot area value. The plot area value must be in square meters.}

\item{strata_area}{Quoted name of the strata area variable, or a numeric vector with the plot strata values. If there are more than 1 area values, it's possible to use a vector with all area values, like so:\code{c(14.4, 16.4, 14.2)}. The strata area values must be in hectares.}

\item{strata}{Quoted name of the subdivision variable(s), also known as strata. If this argument is not supplied, the defined groups in the data frame will be used, if they exist.}

\item{.groups}{Optional argument. Quoted name(s) of additional grouping variable(s) that, if supplied, will be used to run multiple surveys, one for each level. 
If this argument is \code{NA}, the defined groups in the data frame will be used, if they exist. Default: \code{NA}.}

\item{age}{Optional parameter. Quoted name of the age variable. Calculates the average age supplied. \code{NA}.}

\item{alpha}{Numeric value for the significance value used in the t-student estimation. Default: \code{0.05}.}

\item{error}{Numeric value for the minimum admitted error value in the survey, in percentage. Default: \code{10}.}

\item{dec_places}{Numeric value for the number of decimal places to be used in the output tables. Default: \code{4}.}

\item{pop}{Character value for the type of population considered in the calculations. This can be either infinite (\code{"inf"}) or finite (\code{"fin"}). Default: \code{"inf"}.}

\item{tidy}{Boolean value that defines if the output tables should be tidied up or not. Default: \code{TRUE}.}
}
\value{
A list containing two data frames, one with informations for each strata, and one with the stratified sampling results.
}
\description{
Function for processing forest inventory data using stratified random sampling.
}
\details{
This function allows the user to processes inventory data using stratified random sampling for n forest subdivisions (strata),
for finite or infinite populations. It's possible to run multiple sampling analysis using a factor variable indicated in the
\code{.groups}() parameter.
}
\examples{
library(forestmangr)
data("exfm1")
data("exfm2")
data("exfm6")

# The objective is to sample an area, with an error of 5\%.
# First we run a pilot inventory, considering a 5\% error and a finite population:
strs(exfm1, "VWB", "PLOT_AREA", "STRATA_AREA", strata = "STRATA", error = 5, pop = "fin")

# With these results, in order to meet the desired error of 5\%, we'll need to sample 59 more plots,
# 14 in stratum 1, 21 in stratum 2, and 24 in stratum 3.
# After sampling the necessary plots, we now run a definitive inventory,
# considering an 5\% error and a finite population:
strs(exfm2, "VWB", "PLOT_AREA", "STRATA_AREA", strata = "STRATA", error = 5, pop = "fin")

# The desired error value was met.

# Area values can be numeric:
strs(exfm2, "VWB", 1000, c(14.4, 16.4,14.2), strata = "STRATA", error = 5, pop = "fin")

# Optional variable age, and one stratified sampled inventory for each map:
strs(exfm6, "VWB", "PLOT_AREA", "STRATA_AREA", strata ="STRATA", .groups = "MAP", age = "AGE")

}
\references{
Campos, J. C. C. and Leite, H. G. (2017) Mensuracao Florestal: Perguntas e Respostas. 5a. Vicosa: UFV.

Soares, C. P. B., Paula Neto, F. and Souza, A. L. (2012) Dendrometria e Inventario Florestal. 2nd ed. Vicosa: UFV.
}
\seealso{
other sampling functions: 
  \code{\link{sprs}} for Simple Random Sampling, and
  \code{\link{ss_diffs}} for Systematic Sampling.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
\keyword{Random}
\keyword{Sampling}
\keyword{Stratified}
