% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeci.R
\name{makeci}
\alias{makeci}
\title{Create confidence interval grob}
\usage{
makeci(
  est,
  lower,
  upper,
  pch,
  sizes = 1,
  gp = gpar(),
  t_height = NULL,
  xlim = c(0, 1),
  nudge_y = 0,
  name = NULL
)
}
\arguments{
\item{est}{Point estimation. Can be a list for multiple columns
and/or multiple groups. If the length of the list is larger than
then length of \code{ci_column}, then the values reused for each column
and considered as different groups.}

\item{lower}{Lower bound of the confidence interval, same as \code{est}.}

\item{upper}{Upper bound of the confidence interval, same as \code{est}.}

\item{pch}{Numeric or character vector indicating what sort of plotting
symbol to use. See \code{\link[grid]{pointsGrob}}.}

\item{sizes}{Size of the point estimation box, can be a unit, vector or a list.
If the value is not unique, this will first calculate square root of the
reciprocal of size, then devide by overall maximum calculated value.}

\item{gp}{Graphical parameters. Please refer to \code{\link{forest_theme}}
for more details.}

\item{t_height}{The height confidence interval line end vertices. If
value is \code{NULL} (default), no vertices will be drawn.}

\item{xlim}{Limits for the x axis as a vector of length 2, i.e. c(low, high). It
will take the minimum and maximum of the lower and upper value if not provided.
This will apply to all CI columns if provided, and will be calculated automatically
for each column if not provided. This should be a list with the same length of
\code{ci_column} if different \code{xlim} for different column is desired.}

\item{nudge_y}{Horizontal adjustment to nudge groups by, must be within 0 to 1.}

\item{name}{name of the grob.}
}
\value{
A gTree object
}
\description{
Create confidence interval grob
}
