% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG_Server.R
\name{FG_new_fig}
\alias{FG_new_fig}
\title{Initialize New Figure}
\usage{
FG_new_fig(state)
}
\arguments{
\item{state}{FG state from \code{FG_fetch_state()}}
}
\value{
FG state object containing a new empty figure  and that figure set as the
current active figure
}
\description{
Creates a new figure in a FG module
}
\examples{
\donttest{
library(formods)
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = FG_test_mksession(session=list(), full_session=FALSE)
session = sess_res$session
input   = sess_res$input

# This will create a populated FG state object:
state   = sess_res$state

# This sets the current active figure to Fig_1
state[["FG"]][["current_fig"]]  =  "Fig_1"

# This is a paginated figure, and we can access a specific
# figure using the following:
pg_1 = FG_extract_page(state, 1)
pg_2 = FG_extract_page(state, 2)

# This will give you access to the current figure directly:
current_fig = FG_fetch_current_fig(state)

# For example this will set the key for that figure:
current_fig$key = "Individual profiles by cohort (multiple pages)"

# Once you're done you can put it back into the state:
state = FG_set_current_fig(state, current_fig)

# If you made any changes to the actual figure, this will
# force a rebuild of the current figure:
state = FG_build( state=state, del_row = NULL, cmd = NULL)

# To create a new empty figure you can do this:
state = FG_new_fig(state)
}
}
