% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporalMetrics.R
\name{temporalMetrics}
\alias{temporalMetrics}
\title{Calculate temporal summary metrics}
\usage{
temporalMetrics(
  x,
  metrics = "defaultTemporalSummary",
  filename = "",
  stack = TRUE,
  par = FALSE,
  threads = 2,
  progress = TRUE,
  m = 2,
  ...
)
}
\arguments{
\item{x}{List of Raster* or SpatialPointsDataFrame objects.Input Raster or SpatialPointsDataFrame object containing a time series (may be generated with \code{\link[foster]{calcIndices}})}

\item{metrics}{Name of a function  used to process the time series provided as a character.}

\item{filename}{Character. Single output filename including path to directory and eventually extension. Each spectral index is written separately and the name of the spectral index is automatically appended to the file name.}

\item{stack}{Logical. Should the output be returned as a single RasterStack (TRUE) or as a list containing one Raster per vegetation index (FALSE)}

\item{par}{Logical. Should the function be executed in parallel threads}

\item{threads}{Number of parallel threads used if par = TRUE}

\item{progress}{Logical. If TRUE (default) a progress bar is displayed.}

\item{m}{tuning parameter to determine how many blocks will be used (m blocks will be processed by each cluster)}

\item{...}{Other arguments passed to \code{\link[raster]{writeRaster}} or \code{\link[rgdal]{writeOGR}}.}
}
\description{
This function calculates a set of user-defined or default statistics from spectral indices time series.
}
\details{
Spectral indices can be calculated with \code{\link[foster]{calcIndices}}.
The input to \code{TemporalMetrics} is a list where each element is a Raster* or a SpatialPointsDataFrame object with layers or columns being spectral indices. Each element should be one step in the time series and elements should be ordered in the time series ascending order.
The argument \code{fun} defines which metrics will be calculated. It has to be the name of a function that takes a vector as input and returns a named vector corresponding to the summary metrics. The function \code{defaultTemporalSummary} is used by default and returns the median, IQR and Theil-Sen slope of the time series.

If \code{x} is a list of Raster* objects, the processing can be parallelized using \code{\link[raster]{cluster}}. In that case the user has to set \code{par = TRUE} and provide the number of parallel threads \code{threads}. You can control how many blocks will be processed by each thread by setting \code{m} (see \code{\link[raster]{cluster}}).
}
\examples{
# VI_ts is a list of Raster* calculated and saved from calcIndices
# Load it into memory
load(system.file("extdata/examples/VI_ts.RData",package="foster"))

temporalMetrics(VI_ts, metrics = "defaultTemporalSummary")

# User-defined temporal summary metrics can also be used
funSummary <- function(x) {
  c(
    mean = mean(x, na.rm = TRUE),
    median = median(x, na.rm = TRUE),
    std = sd(x, na.rm = TRUE)
  )
}
}
\seealso{
\code{\link[raster]{calc}}, \code{\link[raster]{cluster}}
}
