% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractionl.R
\name{unfractional}
\alias{unfractional}
\title{Demote a fractional object back to a numeric one}
\usage{
unfractional(x)
}
\arguments{
\item{x}{A \code{"fractional"} object}
}
\value{
A simple \code{numeric} object like \code{x}
}
\description{
Given an object of class \code{"fractional"} this simple function
removes the attributes that signal that it is to be treated as a
fractional object, thus returning it to its original \code{numeric}
status alone
}
\examples{
(tst <- fractional(matrix(0:9/10, 2, 5)))
(tst <- unfractional(tst))
}

