% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sunflowers_growth.R
\name{Sunflowers_growth}
\alias{Sunflowers_growth}
\title{Generate size distribution of sunflower pyrite based on different growth mechanisms}
\usage{
Sunflowers_growth(Number_Sunflowers = 1000, Initialization = FALSE,
  framboids, sunflowers, Simulation = 1, Random_Limit = 1, Iterations = 3,
  MaxInfillingVolume = 0.1, MaxMeanDiameter = 20)
}
\arguments{
\item{Number_Sunflowers}{An integer indicanting the number of sunflowers to grow}

\item{Initialization}{If TRUE the growth starts from a framboids data_frame.
If FALSE the growth continues from a sunflower data_frame}

\item{framboids}{When Initialization=TRUE contains the framboid data_frame from which sunflower grow}

\item{sunflowers}{When Initialization=FALSE contains a sunflower data_frame previously grown}

\item{Simulation}{The growth mechanism to simulate.
1,3 surface-controlled,
2-4 supply-controlled,
1,2 size dependent,
3,4 size independent,
5 supply-controlled, increasing volume, size dependent}

\item{Random_Limit}{A number from 0 to 1 representing the maximum value of random numbers
in algorithm}

\item{Iterations}{An integer value that controls the maximum number of iterations of the algorithm}

\item{MaxInfillingVolume}{A value from 0 to 1-packed_factor indicating the maximim infilled volume
of the framboidal core (Simulation = 5)}

\item{MaxMeanDiameter}{A number (in micrometers) controling the maximum mean of the size
distribution of sunflowers}
}
\value{
A sunflower data_frame
}
\description{
Generate size distribution of sunflower pyrite based on different growth mechanisms
}
\examples{
## Size dependent and surface-controlled growth of 100 framboids adding nanocrystals
## until the mean of the diameters of framboids was 10 micrometers followed by size dependent
## and supply-controlled growth until the mean of the diameter was 15 micrometers followed by
## supply-controlled, increasing volume and size dependent growth of sunflowers
## until the mean of the diameter was 20 micrometers
library(frambgrowth)
Framboids<-Framboids_growth(100,Initialization=TRUE, Simulation=1,
Iterations=1000, MaxMeanDiameter=10)
Framboids2<-Framboids_growth(100,Initialization=FALSE, framboids=Framboids, Simulation=5,
Iterations=1000, MaxMeanDiameter=15)
Sunflowers<-Sunflowers_growth(100,Initialization=TRUE, framboids=Framboids2, Simulation=5,
Iterations=1000, MaxMeanDiameter=20)
}
\seealso{
\code{\link{Framboids_growth}}
#' @references
## Merinero, R.; Cardenes, V. (in press)
## Theoretical growth of framboidal and sunflower pyrite using the R-package frambgrowth.
## Mineralogy and Petrology. doi:10.1007/s00710-017-0535-x
}
