% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_search_tags.R
\name{fredr_series_search_tags}
\alias{fredr_series_search_tags}
\title{Get the FRED tags for a series search.}
\usage{
fredr_series_search_tags(series_search_text = NULL, tag_names = NULL,
  tag_group_id = NULL, tag_search_text = NULL, limit = NULL,
  offset = NULL, order_by = NULL, sort_order = NULL,
  realtime_start = NULL, realtime_end = NULL)
}
\arguments{
\item{series_search_text}{A string containing the series search text.
\emph{Required parameter.}}

\item{tag_names}{A semicolon delimited string of tag names to return.  Defaults
no filtering by tag names.}

\item{tag_group_id}{A string indicating the tag group id to filter tags by type.
Defaults to no filtering by tag group.  Possible values are
\itemize{
\item \code{"freq"} = Frequency
\item \code{"gen"} = General or Concept
\item \code{"geo"} = Geography
\item \code{"geot"} = Geography Type
\item \code{"rls"} = Release
\item \code{"seas"} = Seasonal Adjustment
\item \code{"src"} = Source
}}

\item{tag_search_text}{A string to match tag names.  Defaults to no filtering
by tag name matching.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{order_by}{A string indicating the attribute to order results by.
Defaults to \code{"series_count"}. Possible values are:
\itemize{
\item \code{"series_count"}
\item \code{"popularity"}
\item \code{"created"}
\item \code{"name"}
\item \code{"group_id"}
}}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object where each row represents a series tag matching the
query.  Data include the tag name, group ID, tag creation date, popularity,
series count, and additional notes.
}
\description{
Return the FRED tags by searching for matches in series text.
}
\examples{
\donttest{
# Search for tags matching the series text "gnp"
fredr_series_search_tags("gnp")
# Search for tags matching the series text "oil" and the tag text "usa"
fredr_series_search_tags(
  series_search_text = "oil",
  tag_search_text = "usa"
)
# Search for tags matching the series text "oil" and the tag text "usa".
# Return only results in the "geo" (Geography) group
fredr_series_search_tags(
  series_search_text = "oil",
  tag_group_id = "geo",
  tag_search_text = "usa"
)
}
}
\references{
API Documentation:

\href{https://research.stlouisfed.org/docs/api/fred/series_search_tags.html}{series/search/tags}
}
\seealso{
\code{\link[=fredr_series_search_text]{fredr_series_search_text()}}, \code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_tags]{fredr_tags()}}
}
