% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_curv.R
\name{read.fs.morph.gii}
\alias{read.fs.morph.gii}
\title{Read morphometry data file in GIFTI format.}
\usage{
read.fs.morph.gii(filepath, element_index = 1L)
}
\arguments{
\item{filepath, }{string. Full path to the input GIFTI file.}

\item{element_index}{integer, the element to load in case the GIFTI file containes several datasets (usually time series). Defaults to the first element, 1L.}
}
\value{
data, vector of double or integer. The brain morphometry data, one value per vertex. The data type depends on the data type in the file.
}
\description{
Read vertex-wise brain surface data from a GIFTI file. The file must be a GIFTI *func* file (not a GIFTI *surf* file containing a mesh, use \code{\link[freesurferformats]{read_nisurface}} for loading GIFTI surf files).
}
\note{
This function requires the `gifti` package, which is an optional dependency, to be installed. It also assumes that the dataset contains a vector or a matrix/array in which all dimensions except for 1 are empty.
}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.weight}()}

Other gifti readers: 
\code{\link{read.fs.annot.gii}()},
\code{\link{read.fs.label.gii}()},
\code{\link{read.fs.surface.gii}()}
}
\concept{gifti readers}
\concept{morphometry functions}
