% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_weight.R
\name{write.fs.weight.asc}
\alias{write.fs.weight.asc}
\title{Write file in FreeSurfer weight ASCII format}
\usage{
write.fs.weight.asc(filepath, vertex_indices, values)
}
\arguments{
\item{filepath, }{string. Full path to the output ASCII weight file.}

\item{vertex_indices}{vector of integers, the vertex indices. Must be one-based (R-style). This function will substract 1, as they need to be stored zero-based in the file.}

\item{values}{vector of floats. The brain morphometry data to write, one value per vertex.}
}
\description{
Write vertex-wise brain data for a set of vertices to an ASCII file in *weight* format. This format is also known as *paint* format or simply as *w* format.
}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph.ni1}()},
\code{\link{write.fs.morph.ni2}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph.txt}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.weight}()}
}
\concept{morphometry functions}
