% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_patch.R
\name{read.fs.patch.asc}
\alias{read.fs.patch.asc}
\title{Read FreeSurfer ASCII format patch.}
\usage{
read.fs.patch.asc(filepath)
}
\arguments{
\item{filepath}{string. Full path to the input patch file in ASCII patch format.}
}
\value{
named list. The list has the following named entries: "vertices": see return value of \code{\link[freesurferformats]{read.fs.patch}}. "faces": numerical *n*x5 matrix. The columns are named, and appear in the following order: 'face_index1': the one-based (R-style) face index. 'vert1_index1', 'vert2_index1', 'vert3_index1': integer vertex indices of the face, they are one-based (R-style). 'face_index0': the zero-based (C-style) face index.
}
\description{
An ASCII format patch is a part of a brain surface mesh, and is a mesh itself. It consists of vertices and faces. The ASCII patch format is very similar to the ASCII surface format. **Note:** The contents of ASCII and binary patch format files is different. The ASCII patch format is not ideal for parsing, and loading such files is currently quite slow.
}
\seealso{
Other patch functions: \code{\link{fs.patch}},
  \code{\link{read.fs.patch}}, \code{\link{write.fs.patch}}
}
\concept{patch functions}
