% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spilloversRolling.R
\name{spilloverRollingBK09}
\alias{spilloverRollingBK09}
\title{Computing rolling frequency spillover from a fevd as defined by Barunik, Krehlik (2018)}
\usage{
spilloverRollingBK09(
  data,
  n.ahead = 100,
  no.corr,
  partition,
  func_est,
  params_est,
  window,
  cluster = NULL
)
}
\arguments{
\item{data}{variable containing the dataset}

\item{n.ahead}{how many periods ahead should the FEVD be computed, generally this number
should be high enough so that it won't change with additional period}

\item{no.corr}{boolean parameter whether the off-diagonal in the covariance matrix should be
set to zero}

\item{partition}{how to split up the estimated spillovers into frequency bands. Should be
a vector of bound points that starts with 0 and ends with pi+0.00001.}

\item{func_est}{estimation function, usually would be VAR or BigVAR function to estimate
the multivariate system}

\item{params_est}{parameters passed to the estimation function, as a list, for parameters
refer to documentation of the estimating function}

\item{window}{length of the window to be rolled}

\item{cluster}{either NULL for no parallel processing or the variable containing the cluster.}
}
\description{
This function computes the rolling spillover using the standard VAR estimate.
We implement the parallel version for faster processing. The window is of fixed window
and is rolled over the data. Interpretation of the other parameters is the same as in the
standard computation of spillover.
}
\author{
Tomas Krehlik <tomas.krehlik@gmail.com>
}
