% Generated by roxygen2 (4.0.2): do not edit by hand
\name{preprocesshflights}
\alias{preprocesshflights}
\title{Preprocess the \code{hflights} data.}
\usage{
preprocesshflights(hflights)
}
\arguments{
\item{hflights}{\code{hflights} data set}
}
\value{
A preprocessed data set.
}
\description{
Preprocess the \code{hflights} data to get a nice format.
}
\details{
Preprocess this data set.
}
\examples{
if(require(hflights)) {
a <- preprocesshflights(hflights[1:10000,])
summary(a)
}
\dontrun{
library(hflights)
## We create a file with no header
input <- "hflights.csv"
write.table(hflights,file=input,sep=",",
            row.names=FALSE,col.names=FALSE)
## Inefficient way to read the data. Just as example
lines <- readLines(input)
lines <- gsub("\\"","",lines,fixed=TRUE )
x <- strsplit(lines,",")
x <- as.data.frame(do.call("rbind",x))
x <- preprocesshflights(x)
summary(x)
}
}
\seealso{
\code{\link[hflights]{hflights}}
}
\keyword{manip}

