% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_input}
\alias{bs_vars_input}
\title{Bootstrap CSS input variables}
\usage{
bs_vars_input(bg = NULL, color = NULL, border = NULL,
  border_radius = NULL, color_placeholder = NULL,
  group_addon_bg = NULL, border_focus = NULL)
}
\arguments{
\item{bg}{Background color.}

\item{color}{Text color.}

\item{border}{Border color.}

\item{border_radius}{Border radius.}

\item{color_placeholder}{Text color of placeholder.}

\item{group_addon_bg}{Background color of addons.}

\item{border_focus}{Color of border when focused.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 inputs in Bootstrap and Bootswatch themes.
}
\note{
See default parameters for Bootstrap: \url{https://getbootstrap.com/docs/3.4/customize/}.
}
\examples{
# change border radius
bs_vars_input(
  border_radius = "20px"
)


if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    use_theme(create_theme(
      theme = "default",
      bs_vars_input(
        border_radius = "20px"
      )
    )),
    tags$h2("Rounded corner for inputs"),
    textInput("text", "Text:"),
    selectInput("select", "Select:",
                letters, selectize = FALSE)
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
