% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/touch.R
\name{touch}
\alias{touch}
\title{Mock the Unix \command{touch} Utility}
\usage{
touch(path)
}
\arguments{
\item{path}{Path to the file to be touched.}
}
\value{
The Path to the file touched.
}
\description{
Creating a file or ensuring a file's modification time changes.
}
\examples{
file <- tempfile()
touch(file)
t1 <- file.mtime(file)
touch(file)
t2 <- file.mtime(file)
t1 < t2
file <- file.path(tempfile(), "path", "not", "there.txt")
touch(file)
file.exists(file)
}
\seealso{
Other file utilities: 
\code{\link{file_modified_last}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()}
}
\concept{file utilities}
