% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/char2factor.R
\name{char2factor}
\alias{char2factor}
\title{Convert a Character Vector Into a Factor}
\usage{
char2factor(x, levels = unique(x))
}
\arguments{
\item{x}{A character vector.}

\item{levels}{The levels to use, see \code{\link{factor}}.}
}
\value{
A factor.
}
\description{
I often need a factor with levels the unique values of a character vector
(for example: to prevent ggplot2 from sorting the character vector).
}
\examples{
x <- c("beech", "oak", "spruce", "fir")
char2factor(x)
}
\seealso{
Other bits and pieces: 
\code{\link{golden_ratio}()},
\code{\link{is_difftime_less}()},
\code{\link{is_valid_primary_key}()},
\code{\link{pause}()},
\code{\link{r_cmd_install}()},
\code{\link{rownames2col}()},
\code{\link{str2num}()},
\code{\link{string2words}()},
\code{\link{strip_off_attributes}()},
\code{\link{tapply}()},
\code{\link{throw}()}
}
\concept{bits and pieces}
