% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_centsums.R
\docType{class}
\name{centsums-class}
\alias{centsums-class}
\alias{initialize,centsums-method}
\alias{initialize,centsums-class}
\alias{centsums}
\title{centsums Class.}
\usage{
\S4method{initialize}{centsums}(.Object, sums, order = NA_real_)

centsums(sums, order = NULL)
}
\arguments{
\item{.Object}{a \code{centsums} object, or proto-object.}

\item{sums}{a numeric vector.}

\item{order}{the order, defaulting to \code{length(sums)+1}.}
}
\value{
An object of class \code{centsums}.
}
\description{
An S4 class to store (centered) sums of data, and to support operations on 
the same.
}
\details{
A \code{centsums} object contains a vector value of the data count,
the mean, and the \eqn{k}th centered sum, for \eqn{k} up to some
maximum order.
}
\section{Slots}{

\describe{
\item{\code{sums}}{a numeric vector of the sums.}

\item{\code{order}}{the maximum order.}
}}

\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{
obj <- new("centsums",sums=c(1000,1.234,0.235),order=2)

}
\references{
Terriberry, T. "Computing Higher-Order Moments Online."
\url{https://web.archive.org/web/20140423031833/http://people.xiph.org/~tterribe/notes/homs.html}

J. Bennett, et. al., "Numerically Stable, Single-Pass, 
Parallel Statistics Algorithms," Proceedings of IEEE
International Conference on Cluster Computing, 2009.
\doi{10.1109/CLUSTR.2009.5289161}

Cook, J. D. "Accurately computing running variance."
\url{https://www.johndcook.com/standard_deviation/}

Cook, J. D. "Comparing three methods of computing 
standard deviation."
\url{https://www.johndcook.com/blog/2008/09/26/comparing-three-methods-of-computing-standard-deviation/}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{moments}
