% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_group.R
\name{group.annot}
\alias{group.annot}
\title{Load annotations for a group of subjects.}
\usage{
group.annot(subjects_dir, subjects_list, hemi, atlas)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subjects_list, }{vector of strings. The subject identifiers.}

\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{atlas, }{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}
}
\value{
list of annotations, as returned by freesurferformats::read.fs.annot(). If hemi is 'both', the annotations are the results of merging over the hemispheres for each subject.
}
\description{
Load a brain surface annotation, i.e., a cortical parcellation based on an atlas, for a group of subjects.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   subjects_list = c("subject1", "subject2");
   annotations = group.annot(subjects_dir, subjects_list, "lh", "aparc");
}

}
\seealso{
Other atlas functions: \code{\link{get.atlas.region.names}},
  \code{\link{group.agg.atlas.native}},
  \code{\link{group.agg.atlas.standard}},
  \code{\link{regions.to.ignore}},
  \code{\link{spread.values.over.annot}},
  \code{\link{spread.values.over.hemi}},
  \code{\link{spread.values.over.subject}},
  \code{\link{subject.annot}},
  \code{\link{subject.atlas.agg}}
}
\concept{atlas functions}
