% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbar_magick.R
\name{combine.colorbar.with.brainview.animation}
\alias{combine.colorbar.with.brainview.animation}
\title{Combine a colorbar and a brain animation in gif format into a new animation.}
\usage{
combine.colorbar.with.brainview.animation(
  brain_animation,
  colorbar_img,
  output_animation,
  offset = "+0+0",
  extend_brainview_img_height_by = 0L,
  silent = FALSE,
  allow_colorbar_shrink = TRUE,
  background_color = "white"
)
}
\arguments{
\item{brain_animation}{path to the brain animation in GIF format}

\item{colorbar_img}{path to the main image containing the separate colorbar, usually an image in PNG format}

\item{output_animation}{path to output image in gif format, must include the '.gif' file extension}

\item{offset}{offset string passed to \code{magick::image_composite}. Allows you to shift the location of the colorbar in the final image.}

\item{extend_brainview_img_height_by}{integer value in pixels, the size of the lower border to add to the brainview_img. Use this if the lower part of the colorbar is off the image canvas.}

\item{silent}{logical, whether to silence all messages}

\item{allow_colorbar_shrink}{logical, whether to shrink the colorbar to the width of the animation in case it is considerably wider (more than 20 percent). Defaults to TRUE.}

\item{background_color}{color string, the background color to use. Use 'transparency_color' if you want a transparent background.}
}
\description{
Combine a colorbar and a brain animation in gif format into a new animation.
}
\seealso{
Other colorbar functions: 
\code{\link{coloredmesh.plot.colorbar.separate}()},
\code{\link{combine.colorbar.with.brainview.image}()}
}
\concept{colorbar functions}
