% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\docType{methods}
\name{plot.funData}
\alias{plot,funData,missing-method}
\alias{plot.funData}
\title{Plotting univariate functional data}
\usage{
plot.funData(x, y, obs = 1:nObs(x), type = "l", lty = 1, lwd = 1,
  col = NULL, xlab = "argvals", ylab = "", legend = TRUE,
  plotNA = FALSE, add = FALSE, ...)

\S4method{plot}{funData,missing}(x, y, ...)
}
\arguments{
\item{x}{An object of class \code{funData}.}

\item{y}{Missing.}

\item{obs}{A vector of numerics giving the observations to plot. Defaults to 
all observations in \code{x}. For two-dimensional functions (images) 
\code{obs} must have length 1.}

\item{type}{The type of plot. Defaults to \code{"l"} (line plot). See 
\code{\link[graphics]{plot}} for details.}

\item{lty}{The line type. Defaults to \code{1} (solid line). See 
\code{\link[graphics]{par}} for details.}

\item{lwd}{The line width. Defaults to \code{1}. See
\code{\link[graphics]{par}} for details.}

\item{col}{The color of the functions. If not supplied (\code{NULL}, default 
value), one-dimensional functions are plotted in the 
\code{\link[grDevices]{rainbow}} palette and two-dimensional functions are 
plotted using \code{\link[fields]{tim.colors}} from package 
\code{\link[fields]{fields-package}}.}

\item{xlab, ylab}{The titles for x- and y-axis. Defaults to \code{"argvals"}
for the x-axis and no title for the y-axis. See
\code{\link[graphics]{plot}} for details.}

\item{legend}{Logical. If \code{TRUE}, a color legend is plotted for 
two-dimensional functions (images). Defaults to \code{TRUE}.}

\item{plotNA}{Logical. If \code{TRUE}, missing values are interpolated using
the \link{approxNA} function (only for one-dimensional functions). Defaults
to \code{FALSE}.}

\item{add}{Logical. If \code{TRUE}, add to current plot (only for 
one-dimensional functions). Defaults to \code{FALSE}.}

\item{...}{Additional arguments to \code{\link[graphics]{matplot} } 
(one-dimensional functions) or \code{\link[fields]{image.plot}}/ 
\code{\link[graphics]{image}} (two-dimensional functions).}
}
\description{
This function plots observations of univariate functional data on their 
domain.
}
\details{
If some observations contain missing values (coded via \code{NA}), the 
functions can be interpolated using the option \code{plotNA = TRUE}. This 
option relies on the \code{\link[zoo]{na.approx}} function in package 
\code{\link[zoo]{zoo}} and is currently implemented for one-dimensional 
functions only in the function \code{\link{approxNA}}.
}
\section{Warning}{
 The function is currently implemented only for functional 
  data with one- and two-dimensional domains.
}
\examples{
oldpar <- par(no.readonly = TRUE)

# One-dimensional
argvals <- seq(0,2*pi,0.01)
object <- funData(argvals,
                   outer(seq(0.75, 1.25, length.out = 11), sin(argvals)))

plot(object, main = "One-dimensional functional data")

# Two-dimensional
X <- array(0, dim = c(2, length(argvals), length(argvals)))
X[1,,] <- outer(argvals, argvals, function(x,y){sin((x-pi)^2 + (y-pi)^2)})
X[2,,] <- outer(argvals, argvals, function(x,y){sin(2*x*pi) * cos(2*y*pi)})
object2D <- funData(list(argvals, argvals), X)

plot(object2D, main = "Two-dimensional functional data (obs 1)", obs = 1)
plot(object2D, main = "Two-dimensional functional data (obs 2)", obs = 2)
\dontrun{plot(object2D, main = "Two-dimensional functional data")} # must specify obs!

\donttest{
### More examples ###
par(mfrow = c(1,1))

# using plotNA
if(requireNamespace("zoo", quietly = TRUE))
{
objectMissing <- funData(1:5, rbind(c(1, NA, 5, 4, 3), c(10, 9, NA, NA, 6)))
par(mfrow = c(1,2))
plot(objectMissing, type = "b", pch = 20, main = "plotNA = FALSE") # the default
plot(objectMissing, type = "b", pch = 20, plotNA = TRUE, main = "plotNA = TRUE") # requires zoo
}

# Changing colors
plot(object, main = "1D functional data in grey", col = "grey")
plot(object, main = "1D functional data in heat.colors", col = heat.colors(nObs(object)))

plot(object2D, main = "2D functional data in topo.colors", obs = 1, col = topo.colors(64))
par(oldpar)
}
}
\seealso{
\code{\linkS4class{funData}}, \code{\link[graphics]{matplot}}, 
  \code{\link[fields]{image.plot}}, \code{\link[graphics]{image}}
}

