% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_dependency_map.R
\name{build_dependency_map}
\alias{build_dependency_map}
\title{Brief: Build Recursive Dependency Map of User-Defined Functions}
\usage{
build_dependency_map(
  func_name,
  visited = character(),
  all_deps = list(),
  env = parent.frame()
)
}
\arguments{
\item{func_name}{The name of the main function (converted from the main script) to begin tracing dependencies from.}

\item{visited}{A character vector used to track already visited functions and prevent infinite recursion.}

\item{all_deps}{A list used to accumulate the dependency data frames for each user-defined function.}

\item{env}{The local enviroment created in funcMapper()}
}
\value{
A named list of data frames, where each data frame contains the dependencies of a user-defined function.
}
\description{
Description: This function recursively builds a list of data frames, each representing a user-defined function
and its dependencies. Starting from the main function (typically the main script wrapped as a function), it uses
find_dependencies() from the functiondepends package to trace all user-defined function calls. The process
continues until no new dependencies are found.
}
\details{
Author: Antonio Fratamico
Date: 10/07/2025
}
