% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM_plot_functions.R
\name{plot.FRTM_PhaseI}
\alias{plot.FRTM_PhaseI}
\alias{plot.FRTM_PhaseII}
\title{Plot the results of the  Phase I and the Phase II of the FRTM}
\usage{
\method{plot}{FRTM_PhaseI}(x, ...)

\method{plot}{FRTM_PhaseII}(x, ...)
}
\arguments{
\item{x}{The output of  either \code{FRTM_PhaseI} or \code{FRTM_PhaseII}.}

\item{...}{A variable \code{ind_sel} could be provided to select some observations from either the tuning or monitoring set.}
}
\value{
No return value, called for side effects.
}
\description{
This function provides plots of the Hotelling's \eqn{T^{2}} and SPE control charts.
}
\examples{
library(funcharts)
data <- simulate_data_FRTM(n_obs = 20)

data_oc <-
  simulate_data_FRTM(
    n_obs = 2,
    scenario = "1",
    shift = "OC_h",
    severity = 0.5
  )

lambda <- 10 ^ -5
max_x <- max(unlist(data$grid_i))
seq_t_tot <- seq(0, 1, length.out = 30)[-1]
seq_x <- seq(0.1, max_x, length.out = 10)


\dontrun{
  mod_phaseI_FRTM <- FRTM_PhaseI(
    data_tra =  data,
    control.FDTW = list(
      M = 30,
      N = 30,
      lambda = lambda,
      seq_t = seq_t_tot,
      iter_tem = 1,
      iter = 1
    ),
    control.rtr = list(seq_x = seq_x)
  )
  mod_phaseII_FRTM <- FRTM_PhaseII(data_oc = data_oc , mod_phaseI = mod_phaseI_FRTM)

  plot(mod_phaseI_FRTM)
  plot(mod_phaseII_FRTM)
}

}
