% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_fclust.R
\name{fboot_read_one_point}
\alias{fboot_read_one_point}
\title{Read a test of significance of functional clustering}
\usage{
fboot_read_one_point(filename)
}
\arguments{
\item{filename}{a string, used as radical for naming the file
\code{"filename.components.csv"}, \code{"filemane.assemblages.csv"}
or \code{"filemane.performances.csv"}
according to the dimensions of matrices.}
}
\value{
a list of matrices
each containing the results for a clustering index.
  The list is identical to this resulting from the functions
  \code{fboot_assemblages}, \code{fboot_performances}
  or \code{fboot_one_point}.
}
\description{
Read a file of results obtained by
a test of significance of functional clustering.
}
\details{
The functions
  \code{fboot_assemblages}, \code{ftest_performances}
  and \code{fboot_one_point}
  generate a list containing a matrix by clustering index
  ("Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
  "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
  "Sokal_Sneath1" and "Sokal_Sneath2" index).
  Only their dimensions change according the used functions.
  Consequently, a same function is used for recording and reading
  the results of both the test-functions.
}
\keyword{internal}
