% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_fass}
\alias{plot_fass}
\title{Plot performances of some given assemblages}
\usage{
plot_fass(fres, nbcl = 0, main = "Title", opt.ass = NULL )
}
\arguments{
\item{fres}{an object generated by the function \code{\link{fclust}}.}

\item{nbcl}{an integer.
The integer indicates the number of component clusters
to take into account.
It can be lower than or equals to
the optimum number \code{fres$nbOpt} of component clusters.}

\item{main}{a string, that is used
as the first, reference part of the title of each graph.}

\item{opt.ass}{a list, that include
\code{opt.ass = list(sample, who)}.
This option plot modelled and predicted by cross-validation performances
 \emph{versus} observed performances,
 for a small sample of assemblages randomly drawn (\code{sample}),
 or for given, identified assemblages chosen by the user (\code{who}).
 The item order in list is any. \cr

\itemize{
 \item{\code{sample:}}{  an integer. This integer
   specifies the number of assemblages
   to randomly drawn in the assemblage set,
   the plot as the option \code{opt.perf = list("prd")}.
   All chosen assemblages are plotted on a same graph.
   }

 \item{\code{who:}}{  a list of assemblage names.
   The list contains the names of assemblages to plot.
   Each assemblage is plotted on a specific graph.
   This option is useful when ssemblage performances
   are observed over several experiments.
   }
 }}
}
\value{
Nothing. It is a procedure.
}
\description{
The function plots performances
 of some given, identified assemblages.
}
\details{
None.
}
\seealso{
\code{\link{plot_ftrees}} plot primary and secondary trees
 resulting from functional clustering \cr
\code{\link{plot_fperf}} plot observed, modelled and predicted performances
 resulting from functional clustering \cr
\code{\link{plot_fass}} plot performances of some given assemblages \cr
\code{\link{plot_fmotif}} plot as boxplot mean performances
of assemblages sorted by assembly motifs \cr
\code{\link{plot_fcomp}} plot as boxplot mean performances
of assemblages containing a given component \cr
\code{\link{fclust_plot}} plot all possible outputs
of functional clustering
}
\keyword{internal}
